#ifndef PSECTS_PIC16F_MAKRO_INC_
#define PSECTS_PIC16F_MAKRO_INC_
    
;-- Program Section: CODE (ABS) -----------------------------------------------;
;
; Defines a new code section absolutely positioned at specified address
;
; Example 1:
;    PSECT_CODE_ABS RESET_VEC,0x00
;	global	_reset
;    _reset:
;	pgoto	_start
;
; Example 2:
;    PSECT_CODE_ABS INTERRUPT_VEC,0x04
;	global	_isr
;    _isr:
;	retfie
    
PSECT_CODE_ABS MACRO section_name,address
psect section_name,global,class=CODE,abs,ovrld,delta=2,space=0
    org address
ENDM
    
;-- Program Section: CODE -----------------------------------------------------;
;
; Defines a new code section automatically positioned by linker
;
; Example:
;    PSECT_CODE MAIN_PROG
;	global	_start
;    _start:
;	bra	$
    
PSECT_CODE MACRO section_name
psect section_name,global,class=CODE,delta=2,space=0
ENDM
    
;-- Program Section: RAM ------------------------------------------------------;
PSECT_RAM MACRO section_name
psect section_name,global,class=RAM,delta=1,space=1
ENDM
    
;-- Program Section: PSECT_SHR ------------------------------------------------;
;
; Defines a new section automatically positioned by linker 
;  in shared memory (RAM)
;
; Example:
;    PSECT_BANK DATA1,BANK0
;	variable1: DS 1
;	multibyte_variable1: DS 4
    
PSECT_SHR MACRO section_name
psect section_name,global,class=COMMON,delta=1,space=1
ENDM
    
;-- Program Section: BANK -----------------------------------------------------;
;
; Defines a new RAM section automatically positioned by linker in specified bank
;
; Example:
;    PSECT_BANK DATA1,BANK0
;	variable1: DS 1
;	multibyte_variable1: DS 4
    
PSECT_BANK MACRO section_name,bank
psect section_name,global,class=bank,delta=1,space=1
ENDM
    
;-- Program Section: EEPROM ---------------------------------------------------;
;
; Defines a new EEPROM section automatically positioned by linker
;
; Example:
;    PSECT_EEPROM EEDATA1
;	DB 'X',1,2,3,4
    
PSECT_EEPROM MACRO section_name
psect section_name,global,class=EEDATA,delta=1,space=3
ENDM
    
;-- Program Section: IDLOC ----------------------------------------------------;
;
; Defines a new IDLOC section automatically positioned by linker
;
; Example:
;    PSECT_IDLOC IDLOCDATA1
;	DB 0x15
    
PSECT_IDLOC MACRO section_name
psect section_name,global,class=IDLOC,delta=2,space=5
ENDM
; MAKRA  call a goto
;=============================================================================== 

;--------------------------------------------------- 
Mpcall MACRO what	; Call Pagesel
    local here
    pagesel what
    call what
    pagesel here
here:
    ENDM
;........................ Goto Pagesel 
Mpgoto MACRO what
    pagesel what
    goto what
    ENDM
    ;..................... Branch No ZERO
Mbnz MACRO what		;what = co
    btfss   STATUS,2	;bit0=C, bit2=Z
    bra	    what
    ENDM
Mbz MACRO what		; Branch ZERO
    btfsc   STATUS,2	;
    bra	    what
    ENDM    
Mbc MACRO what		; Branch C
    btfsc   STATUS,0	;
    bra	    what
    ENDM   
Mbnc MACRO what		; Branch ZERO
    btfss   STATUS,0	;
    bra	    what
    ENDM        
    ;.................... Skipp CARRY
    Mskpc MACRO what	;
    btfss   STATUS,0	;
    ENDM 
    Mskpnc MACRO what	; Skipp No CARRY
    btfsc   STATUS,0	;
    ENDM 
    ;................... Skipp ZERO
    Mskpz MACRO what	;
    btfss   STATUS,2	;
    ENDM 
    Mskpnz MACRO what	; Skipp NoZERO
    btfsc   STATUS,2	;
    ENDM
    ;.................................
    Mincf16 MACRO reg
    incf	reg,F
    Mskpnz
    incf	reg+1,F
    ENDM
    ;.................................
    Mbtg MACRO reg,bit
    movlw	1 << bit
    xorwf	reg,F
    ENDM  
;=============================================================================== 

#endif // PSECTS_PIC16F_MAKRO_INC_